from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class EugineNier(Player):
    """
    Plays similar to Tit-for-Tat, but with two conditions:
    1) Always Defect on Last Move
    2) If other player defects five times, switch to all defects.

    Names:

    - Eugine Nier: [LessWrong2011]_
    """

    name = "EugineNier"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self):
        super().__init__()
        self.is_defector = False

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if not self.history:
            return C
        if not (self.is_defector) and opponent.defections >= 5:
            self.is_defector = True
        if self.is_defector:
            return D
        return opponent.history[-1]